//test

#ifdef _WIN32_WCE
#undef UNICODE
#undef _UNICODE
#define main my_main
#endif

/* Preprocessor definitions and includes */

#include "ctdbsdk.h" /* c-tree headers */
#include <string.h>
#include <stdio.h>

#define LOCK_SUPPORT

#ifndef ctCLIENT
#ifdef NOTFORCE
#undef LOCK_SUPPORT
#endif
#endif

#define END_OF_FILE INOT_ERR   /* INOT_ERR is ctree's 101 error. See cterrc.h */


/* Global declarations */

CTHANDLE hSession;
CTHANDLE hDatabase;
CTHANDLE hTable;
CTHANDLE hRecord;
int n=1;


/* Function declarations */

#ifdef PROTOTYPE
VOID Initialize(VOID), Define(VOID), Manage(VOID), Done(VOID);
VOID Add_CustomerMaster_Records(VOID), Display_Records(VOID);
VOID Update_CustomerMaster_Record(VOID), Create_CustomerMaster_Table(VOID),Search_CustomerMaster_Record(VOID),Add_CustomerMaster_Record(VOID);
VOID Delete_Records(CTHANDLE), Check_Table_Mode(CTHANDLE);
VOID Handle_Error(CTSTRING);
VOID Myfunction(VOID),display_main(VOID),fun1(VOID),fun2(VOID),fun3(VOID);
#else
VOID Initialize(), Define(), Manage(), Done();
VOID Add_CustomerMaster_Records(), Display_Records();
VOID Delete_Records(), Check_Table_Mode();
VOID Update_CustomerMaster_Record(), Create_CustomerMaster_Table(),Search_CustomerMaster_Record(),Add_CustomerMaster_Record();
VOID Handle_Error();
VOID Myfunction(),display_main(),fun1(),fun2(),fun3();
#endif


/*
 * main()
 *
 * The main() function implements the concept of "init, define, manage
 * and you're done..."
 */

#ifdef PROTOTYPE
NINT main (NINT argc, pTEXT argv[])
#else
NINT main (argc, argv)
NINT argc;
TEXT argv[];
#endif
{
#ifdef LOCK_SUPPORT
   Initialize();

   Define();

   Manage();
   Myfunction();

   Done();
#else
   printf("\ntest");
   printf("\ntest");
   printf("\ntest");
#endif

   printf("\nPress <ENTER> key to exit . . .\n");
#ifndef ctPortWINCE
   getchar();
#endif

   return(0);
}


/*
 * Initialize()
 *
 * Perform the minimum requirement of logging onto the c-tree Server
 */

#ifdef PROTOTYPE
VOID Initialize(VOID)
#else
VOID Initialize()
#endif
{
   CTDBRET  retval;

   printf("INIT\n");

   if ((retval = ctdbStartDatabaseEngine())) 				/* This function is required when you are using the Server DLL model to start the underlying Server. */
	Handle_Error("Initialize(): ctdbStartDatabaseEngine()"); 	/* It does nothing in all other c-tree models */

   /* allocate session handle */
   if ((hSession = ctdbAllocSession(CTSESSION_CTREE)) == NULL)
      Handle_Error("Initialize(): ctdbAllocSession()");

   hDatabase = hSession; /* database not used in this tutorial */

   /* connect to server */
   printf("\tLogon to server...\n");
   if (ctdbLogon(hSession, "FAIRCOMS@10.8.88.138", "ADMIN", "ADMIN"))
      Handle_Error("Initialize(): ctdbLogon()");
}


/*
 * Define()
 *
 * Open the table, if they exist. Otherwise create and open the table
 */

#ifdef PROTOTYPE
VOID Define(VOID)
#else
VOID Define()
#endif
{
   printf("DEFINE\n");

   Create_CustomerMaster_Table();
}


/*
 * Manage()
 *
 * This function performs record adds and updates using locking
 */

#ifdef PROTOTYPE
VOID Manage(VOID)
#else
VOID Manage()
#endif
{
   printf("MANAGE\n");

   /* allocate a record handle */
   if ((hRecord = ctdbAllocRecord(hTable)) == NULL)
      Handle_Error("Manage(): ctdbAllocRecord()");

   /* display contents of table */
   //Display_Records();

}


/*
 * Done()
 *
 * This function handles the housekeeping of closing tables and
 * freeing of associated memory
 */

#ifdef PROTOTYPE
VOID Done(VOID)
#else
VOID Done()
#endif
{
   printf("DONE\n");

   /* close table */
   printf("\tClose table\n");
   if (ctdbCloseTable(hTable))
      Handle_Error("Done(): ctdbCloseTable()");

   /* logout */
   printf("\tLogout...\n");
   if (ctdbLogout(hSession))
      Handle_Error("Done(): ctdbLogout()");

   /* free handles */
   ctdbFreeRecord(hRecord);
   ctdbFreeTable(hTable);
   ctdbFreeSession(hSession);

   /* If you are linked to the Server DLL, then we should stop our Server at the end of the program.   */
   /* It does nothing in all other c-tree models */
   ctdbStopDatabaseEngine();
}


/*
 * Create_CustomerMaster_Table()
 *
 * Open table CustomerMaster, if it exists. Otherwise create it
 * along with its indices and open it
 */

#ifdef PROTOTYPE
VOID Create_CustomerMaster_Table(VOID)
#else
VOID Create_CustomerMaster_Table()
#endif
{
   CTHANDLE pField1, pField2, pField3, pField4;
   CTHANDLE pField5, pField6, pField7;
   CTHANDLE pIndex;
   CTHANDLE pIseg;

   /* define table CustomerMaster */
   printf("\ttable CustomerMaster\n");

   /* allocate a table handle */
   if ((hTable = ctdbAllocTable(hDatabase)) == NULL)
      Handle_Error("Create_CustomerMaster_Table(): ctdbAllocTable()");

   /* open table */
   if (ctdbOpenTable(hTable, "custmast", CTOPEN_NORMAL))
   {
      /* define table fields */
	      pField1 = ctdbAddField(hTable, "cm_custnumb", CT_FSTRING, 4);
	      pField2 = ctdbAddField(hTable, "cm_custzipc", CT_FSTRING, 9);
	      pField3 = ctdbAddField(hTable, "cm_custstat", CT_FSTRING, 2);
	      pField4 = ctdbAddField(hTable, "cm_custflag", CT_STRING, 1);
	      pField5 = ctdbAddField(hTable, "cm_custname", CT_STRING, 47);
	      pField6 = ctdbAddField(hTable, "cm_custaddr", CT_STRING, 47);
	      pField7 = ctdbAddField(hTable, "cm_custphon", CT_STRING, 47);

      if (!pField1 || !pField2 || !pField3 || !pField4 ||
          !pField5 || !pField6|| !pField7)
         Handle_Error("Create_CustomerMaster_Table(): ctdbAddField()");

      /* define index */
      pIndex = ctdbAddIndex(hTable, "cm_custnumb_idx", CTINDEX_FIXED, NO, NO);
      pIseg = ctdbAddSegment(pIndex, pField1, CTSEG_SCHSEG);
      if (!pIndex || !pIseg)
         Handle_Error("Create_CustomerMaster_Table(): ctdbAddIndex()|ctdbAddSegment()");

      /* create table */
      if (ctdbCreateTable(hTable, "custmast", CTCREATE_NORMAL))
         Handle_Error("Create_CustomerMaster_Table(): ctdbCreateTable()");

      /* open table */
      if (ctdbOpenTable(hTable, "custmast", CTOPEN_NORMAL))
         Handle_Error("Create_CustomerMaster_Table(): ctdbOpenTable()");
   }
   else
   {
      Check_Table_Mode(hTable);

      /* confirm the index exists, if not then add the index
       *
       * this scenario arises out of the fact that this table was created in tutorial 1
       * without indexes. The index is now created by the call to ctdbAlterTable
       */

      if (ctdbGetIndexByName(hTable, "cm_custnumb_idx") == NULL)
      {
         pField1 = ctdbGetFieldByName(hTable, "cm_custnumb");
         pIndex = ctdbAddIndex(hTable, "cm_custnumb_idx", CTINDEX_FIXED, NO, NO);
         pIseg = ctdbAddSegment(pIndex, pField1, CTSEG_SCHSEG);
         if (!pIndex || !pIseg)
            Handle_Error("Create_CustomerMaster_Table(): ctdbAddIndex()|ctdbAddSegment()");

         if (ctdbAlterTable(hTable, CTDB_ALTER_NORMAL) != CTDBRET_OK)
            Handle_Error("Create_CustomerMaster_Table(): ctdbAlterTable()");
      }
   }
}


/*
 * Check_Table_Mode()
 *
 * Check if existing table has transaction processing flag enabled.
 * If a table is under transaction processing control, modify the
 * table mode to disable transaction processing
 */

#ifdef PROTOTYPE
VOID Check_Table_Mode(CTHANDLE hTable)
#else
VOID Check_Table_Mode(hTable)
CTHANDLE hTable;
#endif
{
   CTCREATE_MODE mode;

   /* get table create mode */
   mode = ctdbGetTableCreateMode(hTable);

   /* check if table is under transaction processing control */
   if ((mode & CTCREATE_TRNLOG))
   {
      /* change file mode to disable transaction processing */
      mode ^= CTCREATE_TRNLOG;
      if (ctdbUpdateCreateMode(hTable, mode) != CTDBRET_OK)
         Handle_Error("Check_Table_Mode(); ctdbUpdateCreateMode");
   }
}


/*
 * Handle_Error()
 *
 * This function is a common bailout routine. It displays an error message
 * allowing the user to acknowledge before terminating the application
 */

#ifdef PROTOTYPE
VOID Handle_Error(CTSTRING errmsg)
#else
VOID Handle_Error(errmsg)
CTSTRING errmsg;
#endif
{
   printf("\nERROR: [%d] - %s \n", ctdbGetError(hSession), errmsg);
   printf("*** Execution aborted *** \nPress <ENTER> key to exit...");

   ctdbLogout(hSession);

   ctdbFreeRecord(hRecord);
   ctdbFreeTable(hTable);
   ctdbFreeSession(hSession);

   getchar();

   exit(1);
}

#ifdef PROTOTYPE
VOID Myfunction(VOID)
#else
VOID Myfunction()
#endif
{
	while(1)
	{

		Update_CustomerMaster_Record();
		printf("Updating");

		sleep(0.5);
	}


}

#ifdef PROTOTYPE
VOID Update_CustomerMaster_Record(VOID)
#else
VOID Update_CustomerMaster_Record()
#endif
{
	int choice;
	char temp;
   TEXT num[10],name[47];
   TEXT		custnumb[4+1];
   TEXT		custzipc[9+1];
   TEXT		custname[47+1];
   TEXT		custaddr[47+1];
   TEXT		custphon[47+1];
   CTDBRET  retval;

   /* enable session-wide lock flag */
   if (ctdbLock(hSession, CTLOCK_WRITE_BLOCK))
      Handle_Error("Update_CustomerMaster_Record(): ctdbLock()");

   /* find record by customer number */
   if (ctdbClearRecord(hRecord))
      Handle_Error("Update_CustomerMaster_Record(): ctdbClearRecord()");
   if (ctdbSetFieldAsString(hRecord, 0, "1001"))
      Handle_Error("Update_CustomerMaster_Record(): ctdbSetFieldAsString()");
   if (ctdbFindRecord(hRecord, CTFIND_EQ))
      printf("Sorry, can't find this Reocrd");


   retval |= ctdbGetFieldAsString(hRecord, 0, custnumb, sizeof(custnumb));
   retval |= ctdbGetFieldAsString(hRecord, 1, custzipc, sizeof(custzipc));
   //retval |= ctdbGetFieldAsString(hRecord, 3, custphon, sizeof(custphon));
   retval |= ctdbGetFieldAsString(hRecord, 4, custname, sizeof(custname));
   retval |= ctdbGetFieldAsString(hRecord, 5, custaddr, sizeof(custaddr));
   retval |= ctdbGetFieldAsString(hRecord, 6, custphon, sizeof(custphon));

   if(n==1)
   {
	   if (ctdbSetFieldAsString(hRecord, 6, "0000000000"))
	      Handle_Error("Update_CustomerMaster_Record(): ctdbSetFieldAsString()");
	   /* rewrite record */
	   if (ctdbWriteRecord(hRecord))
	      Handle_Error("Update_CustomerMaster_Record(): ctdbWriteRecord()");
	   n=0;
   }
   else
   {
	   if (ctdbSetFieldAsString(hRecord, 6, "9999999999"))
	      Handle_Error("Update_CustomerMaster_Record(): ctdbSetFieldAsString()");
	   /* rewrite record */
	   if (ctdbWriteRecord(hRecord))
	      Handle_Error("Update_CustomerMaster_Record(): ctdbWriteRecord()");
	   n=1;
   }

   if (ctdbUnlock(hSession))
      Handle_Error("Update_CustomerMaster_Record(): ctdbUnlock()");

}




